#include "gl.h"
#include "gengine.h"
#include "..\common.h"

Anything::Anything()
{
	pic = NULL;
}

Anything::~Anything()
{
	if( pic ){
		for( int i=0; i<frames;i++ )
			delete pic[i];
		delete pic;
	}
}

int StillObj::LoadPicture( char *entname, int level )
{
	char entryname[64], levelNo[3] = "00";
	if( level < 0 || level > 99 )
		return -1;

	strcpy( entryname, entname );
	// free pictures
	if( pic ){
		for( int i=0; i<frames;i++ )
			delete pic[i];
		delete pic;
	}
	// create entryname
	if( level < 10 )
		_itoa( level, levelNo+1, 10 );
	else
		_itoa( level, levelNo, 10 );
	strcat( entryname, levelNo );

	char *fname;	//ļͼƬļ
	// open default config file
	if( ConfigSetFile( DEFAULT_CONFIG_FILE_NAME ) != 0 ){
		FailMsg( "Open config file failed" );
	}
	if(( fname = ConfigGetString( "graphic engine", entryname, NULL )) == NULL ){
		FailMsg( "config file error" );
	}

	File *sfp;
	char temp[256];
	sfp = cfile.Open( fname );
	if( sfp == NULL ){
		FailMsg( "open pic file failed" );
	}
	if( sfp->Gets( temp, 256 ) == NULL )
		return -1;
	frames = atoi( temp );

	pic = (Bitmap**)new char[frames*sizeof( Bitmap* )];
	if( pic == NULL )
		return -1;
	ZeroMemory( pic, frames*sizeof( Bitmap* ));

	for( int i=0; i<frames; i++ ){
		if( sfp->Gets( temp, 256 ) == NULL )
			break;
		if( temp[strlen(temp)-2] == '\r' || temp[strlen(temp)-2] == '\n' )
			temp[strlen(temp)-2] = 0;
		if(( pic[i] = ::LoadPicture( temp, 1 )) == NULL )
			FailMsg( "read pic file failed" );
	}
	sfp->Close();
	return 0;
}

// 
int Ground::LoadPicture( int level )
{// ļӦͼƬ
	width = 64;
	height = 31;
	baseX = 32;
	baseY = 16;

	return StillObj::LoadPicture( "groundpic", level );
}

void Ground::Draw( Bitmap* dest, int x, int y, int picno )
{
	if( picno < frames ){
		SpriteBlitBeta( dest, x - baseX, y - baseY, pic[picno] );
	}
}

// ǽ
int WallBase::LoadPicture( int level )
{
	width = 64;
	height = 31;
	baseX = 32;
	baseY = 16;

	return StillObj::LoadPicture( "wallbasepic", level );
}

void WallBase::Draw( Bitmap* dest, int x, int y, int picno )
{
	if( picno < frames ){
		SpriteBlitBeta( dest, x - baseX, y - baseY, pic[picno] );
	}
}

// ǽ
short Wall::bright[32] = {0};
int Wall::LoadPicture( int level )
{// ļӦͼƬ
	width = 32;
	height = 97;
	baseX = 16;
	baseY = 96;

	return StillObj::LoadPicture( "wallpic", level );
}

void Wall::Draw( Bitmap* dest, int x, int y, int picno )
{
	if( picno < frames ){
		//SpriteSetDrawMode( Bitmap::BetaMode, GetBrightness(x,y));
		SpriteBlitBeta10MMX( dest, x-baseX, y-baseY, pic[picno], 
			GetBrightness( x-baseX, y-16 ), GetBrightness( x+15, y-16 ), bright );
		//SpriteBlitBeta9MMX( dest, x-baseX, y-baseY, pic[picno], GetBrightness( x, y-16 ));
	}
}
